<?php
	require '../Com.php';
	valUs();
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>Ventas</title>
	<link rel="stylesheet" type="text/css" href="../css/bootstrap/css/bootstrap.min.css">
    <script src="../css/bootstrap/js/bootstrap.bundle.min.js"></script>
    <link rel="icon" href="../images/icon.png">
    <script type="text/javascript">
    	function buscar() {
			var input, filter, table, tr, td, i, txtValue;
			input = document.getElementById("buscador");
			filter = input.value.toUpperCase();
			table = document.getElementById("tabla");
			tr = table.getElementsByTagName("tr");

			for (i = 0; i < tr.length; i++) {
				td = tr[i].getElementsByTagName("td")[2];
				if (td) {
					txtValue = td.textContent || td.innerText;
					if (txtValue.toUpperCase().indexOf(filter) > -1) {
						tr[i].style.display = "";
					} else {
						tr[i].style.display = "none";
					}
				}
			}
		}
		
		function pago(quien){
			var datos = document.getElementById(quien);
			var tipo = datos.getAttribute("data-tipo");
			var ref = datos.getAttribute("data-ref");
			document.getElementById("tipo").value = tipo;
			document.getElementById("ref").value = ref;
		}

		function filtrar(cual){
			var filas = document.getElementsByTagName("tr");
			for (i = 0; i < filas.length; i++){
				filas[i].style.display = "none";
			}
			var si = document.getElementsByClassName(cual);
			for (j=0; j < si.length; j++){
				si[j].style.display = "table-row";
			}
		}

		function quitarF(){
			var filas = document.getElementsByTagName("tr");
			for (i = 0; i < filas.length; i++){
				filas[i].style.display = "table-row";
			}
		}
		
		function cambioCliente(){
			var valor = document.getElementById("cliente").value;
			if (valor == "nuevo"){
				document.getElementById("desaparece").style.display = "flex";
				document.getElementById("direccion").readOnly= false;
				document.getElementById("empresa").readOnly= false;
			}
			else{
				document.getElementById("desaparece").style.display = "none";
				document.getElementById("direccion").readOnly= true;
				document.getElementById("empresa").readOnly= true;
				var data = document.getElementById("c" + valor);
				var emp = data.getAttribute("data-emp");
				var dir = data.getAttribute("data-dir");
				document.getElementById("empresa").value = emp;
				document.getElementById("direccion").value = dir;
			}
		}
    </script>
    <style>
        .input-group {
            margin: 2% auto;
        }
        
        .parcial {
            background-color: orange;
        }
    </style>
</head>
<body>
	<?php
		require '../nav.php';
		$ventas = mysqli_query($con, "SELECT * FROM prefacturas WHERE Bodega='$bodega' AND Liquidado='1' AND Completado='0' ORDER BY Fecha DESC");
	?>
	<table class="table table-striped" id="tabla">
		<thead>
			<tr>
				<th>Número</th>
				<th>Fecha</th>
				<th>Cliente</th>
				<th>Total</th>
				<th>Estambre</th>
				<th>Complemento</th>
				<th>Aprobado</th>
				<th></th>
				<th><input type="text" id="buscador" class="form-control" onkeyup="buscar()" placeholder="Buscar por cliente"></th>
			</tr>
		</thead>
		<tbody>
<?php
	$i = 0;
	while ($v = mysqli_fetch_assoc($ventas)){
	    $consec = $v["Consec"];
		$clase = "";
		//if ($v["Credito"] == '1'){
		//	$cred = "Con crédito";
		//	$clase = $clase . "cred ";
		//}
		//else{
		//	$cred = "Contado";
		//}
		$liq = "0";
		if ($v["SalEst"] == '1' or mysqli_num_rows(mysqli_query($con, "SELECT Consec FROM prefacdet WHERE Prefactura='$consec' AND Producto IN (SELECT Clave FROM productos WHERE Categoria='prod')")) == 0){
			$estambre = "Completado";
		}
		else{
			$estambre = "Pendiente";
		}
		if ($v["AcomodoCompl"] != '' or mysqli_num_rows(mysqli_query($con, "SELECT Consec FROM prefacdet WHERE Prefactura='$consec' AND Producto IN (SELECT Clave FROM productos WHERE Categoria='compl')")) == 0){
			$comp = "Completado";
		}
		else{
			$comp = "Pendiente";
		}
		if ($v["Autorizado"] == '1'){
			$aprob = "Aprobado";
		}
		else{
			$aprob = "No aprobado";
		}
		$cliente = $v["Cliente"];
		$consec = $v["Consec"];
		echo '
			<form action="finSalEst.php" method="POST" id="term', $i,'" style="display: none;">
				<input type="hidden" name="clave" value="', $v["Consec"],'">
			</form>
			<form action="borrCot.php" method="POST" id="pago', $i,'" style="display: none;">
				<input type="hidden" name="clave" value="', $v["Consec"],'">
			</form>
			<form action="acomEst.php" method="POST" id="sal', $i,'" style="display: none;">
				<input type="hidden" name="clave" value="', $v["Consec"],'">
			</form>
		';
		if (mysqli_num_rows(mysqli_query($con, "SELECT * FROM inventario WHERE Apartado='p$consec'")) > 0){
		    echo '
		    <tr id="', $v["Consec"],'" data-tipo="', $v["TipoPago"],'" data-ref="', $v["Referencia"],'" class="parcial">
		    ';
		}
		else {
		    echo '
			<tr id="', $v["Consec"],'" data-tipo="', $v["TipoPago"],'" data-ref="', $v["Referencia"],'">
			';
		}
		echo '
				<td>', $v["Consec"],'</td>
				<td>', $v["Fecha"],'</td>
				<td>', mysqli_fetch_assoc(mysqli_query($con, "SELECT Nombre FROM clientes WHERE Consec='$cliente'"))["Nombre"],'</td>
				<td>$', $v["Total"],'</td>
				<td>', $estambre,'</td>
				<td>', $comp,'</td>
				<td>', $aprob,'</td>
		';
		if ($v["SalEst"] != "1"){
			echo '
				<td><button class="btn btn-primary" onclick="document.getElementById(\'sal', $i,'\').submit()">Acomodo estambre</button></td>
				<td></td>
			';
		}
		else{
		    echo '
				<td></td>
			';
		    if ($comp == "Completado" and $v["Autorizado"] == "1"){
			    echo '
			    	<td><button class="btn btn-primary" onclick="document.getElementById(\'term', $i,'\').submit()">Terminar salida</button></td>
			    ';
		    }
		    else{
		        echo '
			    	<td></td>
			    ';
		    }
		}
		echo '
			</tr>
		';
		$i++;
	}
?>
		</tbody>
	</table>
</body>
</html>


