<?php
	require '../Com.php';
	valUs();
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>Facturar</title>
	<link rel="stylesheet" type="text/css" href="../css/bootstrap/css/bootstrap.min.css">
    <script src="../css/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <link rel="icon" href="../images/icon.png">
    <script type="text/javascript">
    	function buscar() {
			var input, filter, table, tr, td, i, txtValue;
			input = document.getElementById("buscador");
			filter = input.value.toUpperCase();
			table = document.getElementById("tabla");
			tr = table.getElementsByTagName("tr");

			for (i = 0; i < tr.length; i++) {
				td = tr[i].getElementsByTagName("td")[2];
				if (td) {
					txtValue = td.textContent || td.innerText;
					if (txtValue.toUpperCase().indexOf(filter) > -1) {
						tr[i].style.display = "";
					} else {
						tr[i].style.display = "none";
					}
				}
			}
		}
    </script>
    <style>
        .input-group {
            margin: 2% auto;
        }
    </style>
    <script type="text/javascript">
        function factura(quien){
			var datos = document.getElementById(quien);
			var rfc = datos.getAttribute("data-rfc");
			var razon = datos.getAttribute("data-razon");
			var dir = datos.getAttribute("data-dir");
			var col = datos.getAttribute("data-col");
			var ciudad = datos.getAttribute("data-ciudad");
			var reg = datos.getAttribute("data-regimen");
			var cp = datos.getAttribute("data-cp");
			var consec = datos.getAttribute("data-consec");
			document.getElementById("rfc").value = rfc;
			document.getElementById("razon").value = razon;
			document.getElementById("direccion").value = dir;
			document.getElementById("col").value = col;
			document.getElementById("cp").value = cp;
			if(consec != null){
			document.getElementById("consec").value = consec;
			}
			document.getElementById("ciudad").value = ciudad;
			document.getElementById(reg).selected = true;
			document.getElementById("venta").value = quien;
		}
		
		function seleccion(x){
		    var rfcs = document.getElementById("datos");
		    while (rfcs.hasChildNodes()){
		        rfcs.removeChild(rfcs.firstChild);
		    }
		    var divs = document.getElementsByClassName(x);
		    for (var i; i < divs.length; i++){
		        var rfc = divs[i].getAttribute("data-rfc");
		        const opcion = document.createElement("option");
		        opcion.value = rfc;
		        opcion.innerHTML = divs[i].getAttribute("data-rfc");
		        if (divs[i].getAttribute("data-primario") == "1"){
		            opcion.selected = true;
		        }
		        opcion.id = rfc;
		        opcion.setAttribute("data-confirm", divs[i].getAttribute("data-confirm"));
		        opcion.setAttribute("data-venta", divs[i].getAttribute("data-venta"));
		        opcion.setAttribute("data-consec", divs[i].getAttribute("data-consec"));
		        opcion.setAttribute("data-rfc", divs[i].getAttribute("data-rfc"));
		        rfcs.appendChild(opcion);
		    }
		}
		
		function multiples(){
		    var datos = document.getElementById("datos");
		    var opcion = document.getElementById(datos.value);
		    if (opcion.getAttribute("data-confirm") == 1){
		        imprimir(opcion.getAttribute("data-venta"), opcion.getAttribute("data-consec"));
		    }
		    else{
		        document.getElementById("consec") = opcion.getAttribute("data-consec");
		        factura(opcion.getAttribute("data-rfc"));
		        $('#facturacion').modal('show');
		    }
		}
		
		function imprimir(x, y){
		    document.getElementById("finalFac").value = y;
		    document.getElementById("finalVenta").value = x;
		    $('#imprimir').modal('show');
		}
		
		function datos(){
		    var datos = document.getElementById("datos");
		    var opcion = document.getElementById("d" + datos.value);
		    var rfc = opcion.dataset.rfc;
		    var razon = opcion.dataset.razon;
		    var dir = opcion.dataset.dir;
		    var col = opcion.dataset.col;
		    var ciu = opcion.dataset.ciu;
		    var reg = opcion.dataset.reg;
		    var cop = opcion.dataset.cop;
		    document.getElementById("rfc").value = rfc;
		    document.getElementById("razon").value = razon;
		    document.getElementById("direccion").value = dir;
		    document.getElementById("col").value = col;
		    document.getElementById("ciudad").value = ciu;
		    document.getElementById("cp").value = cop;
		    var regs = document.getElementsByClassName("regs");
		    for (var i = 0; i < regs.length; i++){
		        regs[i].selected = false;
		    }
		    document.getElementById("r" + reg).selected = true
		    document.getElementById("rfcMost").innerHTML = rfc;
		    document.getElementById("razonMost").innerHTML = razon;
		    document.getElementById("dirMost").innerHTML = dir;
		    document.getElementById("colMost").innerHTML = col;
		    document.getElementById("ciuMost").innerHTML = ciu;
		    document.getElementById("copMost").innerHTML = cop;
		    document.getElementById("regMost").innerHTML = reg;
		}
    </script>
</head>
<body>
	<?php
		require '../nav.php';
		$ventas = mysqli_query($con, "SELECT * FROM carresumen WHERE Liquidado='1' AND Bodega='$bodega' ORDER BY Fecha DESC");
	?>
	<table class="table table-striped" id="tabla">
		<thead>
			<tr>
				<th>Número</th>
				<th>Fecha</th>
				<th>Cliente</th>
				<th>Total</th>
				<th><input type="text" id="buscador" class="form-control" onkeyup="buscar()" placeholder="Buscar por cliente"></th>
			</tr>
		</thead>
		<tbody>
<?php
	$i = 0;
	while ($v = mysqli_fetch_assoc($ventas)){
	    $c = $v["Cliente"];
	    $cliente = $c;
	    $fac = mysqli_fetch_assoc(mysqli_query($con, "SELECT * FROM datosfac WHERE Cliente='$cliente' AND Principal='1'"));
		echo '
			<form action="divFac.php" method="POST" id="div', $i,'" style="display: none;">
				<input type="hidden" name="clave" value="', $v["Consec"],'">
			</form>
			<tr id="', $v["Consec"],'" data-rfc="', $fac["Rfc"],'" data-razon="', $fac["Razon"],'" data-dir="', $fac["Direccion"],'" data-regimen="', $fac["Regimen"],'" data-col="', $fac["Colonia"],'" data-ciudad="', $fac["Ciudad"],'" data-cp="', $fac["CodigoPostal"],'" data-consec="', $fac["Consec"],'">
				<td>', $v["Consec"],'</td>
				<td>', $v["Fecha"],'</td>
				<td>', $c,'</td>
				<td>', $v["Total"],'</td>
		';
		$datos = mysqli_query($con, "SELECT * FROM datosfac WHERE Cliente='$cliente'");
		if (mysqli_num_rows($datos) == 1){
		    $d = mysqli_fetch_assoc($datos);
		    if ($d["Confirmada"] == 1){
		        echo '
				<td><button class="btn btn-primary" onclick="imprimir(\'', $v["Ticket"], '\', \'', $fac["Consec"], '\')">Generar factura</button></td>
				';
		    }
		    else{
		        echo '
				<td><button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#facturacion" onclick="factura(\'', $v["Consec"],'\')">Generar factura</button></td>
				';
		    }
		}
		else{
		    while ($d = mysqli_fetch_assoc($datos)){
                echo '
                <div style="display: none;" id="', $d["Rfc"],'" data-primario="', $d["Principal"],'" data-confirm="', $d["Confirmada"],'" data-rfc="', $d["Rfc"],'" data-razon="', $d["Razon"],'" data-dir="', $d["Direccion"],'" data-regimen="', $d["Regimen"],'" data-col="', $d["Colonia"],'" data-ciudad="', $d["Ciudad"],'" data-cp="', $d["CodigoPostal"],' data-consec="', $d["Consec"],'" class="', $v["Consec"],'"></div>
                ';
		    }
		    echo '
			    <td><button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#selDatos" onclick="seleccion(\'', $v["Consec"],'\')">Generar factura</button></td>
			';
		}
		//echo '
		//		<td><button class="btn btn-primary" onclick="document.getElementById(\'div', $i,'\').submit()">Dividir facturas</button></td>
		//';
		echo '
			</tr>
		';
		$i++;
	}
?>
		</tbody>
	</table>
	<div class="modal fade" data-bs-backdrop="static" tabindex="-1" role="dialog" id="facturacion">
		<div class="modal-dialog modal-xl" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h3>Datos de facturación</h3>
					<button type="button" class="btn-close" aria-label="close" data-bs-dismiss="modal"></button>
				</div>
				<div class="modal-body">
				<form action="guardDatosFacGen.php" method="POST">
				    <input type="hidden" id="consec" name="consec" value="0">
				    <input type="hidden" id="venta" name="venta" value="0">
			<?php
	            echo '
	                <input type="hidden" name="cliente" value="', $cliente,'">
	            ';
	        ?>
	                <div class="form-floating">
                	    <select name="datos" id="datos" class="form-select datosfac" onchange="datos()">
                	        <option id="d0" value="0" data-rfc="" data-razon="" data-dir="" data-col="" data-ciu="" data-reg="" data-cop="">Nuevo</option>
            <?php
                $datos = mysqli_query($con, "SELECT * FROM datosfac WHERE Cliente='$cliente'");
                while ($d = mysqli_fetch_assoc($datos)){
                    if ($d["Principal"]){
                        echo '
                            <option id="d', $d["Consec"],'" value="', $d["Consec"],'" data-rfc="', $d["Rfc"],'" data-razon="', $d["Razon"],'" data-dir="', $d["Direccion"],'" data-col="', $d["Colonia"],'" data-ciu="', $d["Ciudad"],'" data-reg="', $d["Regimen"],'" data-cop="', $d["CodigoPostal"],'" selected onload="datos()">', $d["Rfc"],'</option>
                        ';
                    }
                    else{
                        echo '
                            <option id="d', $d["Consec"],'" value="', $d["Consec"],'" data-rfc="', $d["Rfc"],'" data-razon="', $d["Razon"],'" data-dir="', $d["Direccion"],'" data-col="', $d["Colonia"],'" data-ciu="', $d["Ciudad"],'" data-reg="', $d["Regimen"],'" data-cop="', $d["CodigoPostal"],'">', $d["Rfc"],'</option>
                        ';
                    }
                }
            ?>
            	        </select>
                    </div>
					<div class="input-group">
						<label class="input-group-text" for="rfc">RFC</label>
						<input type="text" class="form-control" name="rfc" id="rfc" required>
					</div>
					<div class="input-group">
						<label class="input-group-text" for="razon">Razón social</label>
						<input type="text" class="form-control" name="razon" id="razon" required>
					</div>
					<div class="input-group">
						<label class="input-group-text" for="cp">Código postal</label>
						<input type="number" max="99999" class="form-control" name="cp" id="cp" required>
					</div>
					<div class="input-group">
						<label class="input-group-text" for="direccion">Dirección</label>
						<input type="text" class="form-control" id="direccion" name="direccion" required>
					</div>
					<div class="input-group">
						<label class="input-group-text" for="col">Colonia</label>
						<input type="text" class="form-control" name="col" id="col" required>
					</div>
					<div class="input-group">
						<label class="input-group-text" for="ciudad">Ciudad</label>
						<input type="text" class="form-control" name="ciudad" id="ciudad" required>
					</div>
					<div class="input-group">
						<label class="input-group-text" for="reg">Régimen</label>
						<select class="form-select" id="reg" name="reg" required>
			            	<option></option>
    	        <?php
    	            $regimenes = mysqli_query($con, "SELECT * FROM regimenes");
    	            while ($r = mysqli_fetch_assoc($regimenes)){
    	                echo '
    	                    <option value="', $r["Clave"],'" id="', $r["Clave"],'">', utf8_encode($r["Nombre"]),'</option>
    	                ';
    	            }
    	        ?>
			            </select>
					</div>
					<div class="form-floating">
		            	<select class="form-select" id="cfdi" name="cfdi" required>
		            		<option></option>
		            		<option value="G01 Adquisicion de mercancias">G01 Adquisicion de mercancias</option>
		            		<option value="G03 Gastos en general">G03 Gastos en general</option>
		            	</select>
		            	<label for="sec">Uso de cfdi</label>
		            </div>
					<button type="submit" class="btn btn-primary">Guardar</button>
					</form>
				</div>
			</div>
		</div>
	</div>
	
	<div class="modal fade" data-bs-backdrop="static" tabindex="-1" role="dialog" id="selDatos">
		<div class="modal-dialog modal-xl" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h3>Seleccione</h3>
					<button type="button" class="btn-close" aria-label="close" data-bs-dismiss="modal"></button>
				</div>
				<div class="modal-body">
					<div class="input-group">
						<label class="input-group-text" for="datos">Rfc</label>
						<select class="form-select" id="datos" name="datos" required>
			            	<option></option>
			            </select>
					</div>
					<button type="button" class="btn btn-primary" onclick="multiples()">Seleccionar</button>
				</div>
			</div>
		</div>
	</div>
	
	<div class="modal fade" data-bs-backdrop="static" tabindex="-1" role="dialog" id="imprimir">
		<div class="modal-dialog modal-xl" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h3>Seleccione</h3>
					<button type="button" class="btn-close" aria-label="close" data-bs-dismiss="modal"></button>
				</div>
				<div class="modal-body">
				    <form action="impFac.php" method="POST">
				        <input type="hidden" name="clave" id="finalVenta">
    			    	<input type="hidden" name="datos" id="finalFac">
					<div class="form-floating">
		            	<select class="form-select" id="cfdi" name="cfdi" required>
		            		<option></option>
		            		<option value="G01 Adquisicion de mercancias">G01 Adquisicion de mercancias</option>
		            		<option value="G03 Gastos en general">G03 Gastos en general</option>
		            	</select>
		            	<label for="sec">Uso de cfdi</label>
		            </div>
					<button type="submit" class="btn btn-primary">Seleccionar</button>
					</form>
				</div>
			</div>
		</div>
	</div>
</body>
</html>


