<?php
	require '../Com.php';
	valUs();
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>Ventas</title>
	<link rel="stylesheet" type="text/css" href="../css/bootstrap/css/bootstrap.min.css">
    <script src="../css/bootstrap/js/bootstrap.bundle.min.js"></script>
    <link rel="icon" href="../images/icon.png">
    <script type="text/javascript">
    	function buscar() {
			var input, filter, table, tr, td, i, txtValue;
			input = document.getElementById("buscador");
			filter = input.value.toUpperCase();
			table = document.getElementById("tabla");
			tr = table.getElementsByTagName("tr");

			for (i = 0; i < tr.length; i++) {
				td = tr[i].getElementsByTagName("td")[2];
				if (td) {
					txtValue = td.textContent || td.innerText;
					if (txtValue.toUpperCase().indexOf(filter) > -1) {
						tr[i].style.display = "";
					} else {
						tr[i].style.display = "none";
					}
				}
			}
		}
		
		function pago(quien){
			var datos = document.getElementById(quien);
			var tipo = datos.getAttribute("data-tipo");
			var ref = datos.getAttribute("data-ref");
			document.getElementById("tipo").value = tipo;
			document.getElementById("ref").value = ref;
		}

		function filtrar(cual){
			var filas = document.getElementsByTagName("tr");
			for (i = 0; i < filas.length; i++){
				filas[i].style.display = "none";
			}
			var si = document.getElementsByClassName(cual);
			for (j=0; j < si.length; j++){
				si[j].style.display = "table-row";
			}
		}

		function quitarF(){
			var filas = document.getElementsByTagName("tr");
			for (i = 0; i < filas.length; i++){
				filas[i].style.display = "table-row";
			}
		}
		
		function cambioCliente(){
			var valor = document.getElementById("cliente").value;
			if (valor == "nuevo"){
				document.getElementById("desaparece").style.display = "flex";
				document.getElementById("direccion").readOnly= false;
				document.getElementById("empresa").readOnly= false;
			}
			else{
				document.getElementById("desaparece").style.display = "none";
				document.getElementById("direccion").readOnly= true;
				document.getElementById("empresa").readOnly= true;
				var data = document.getElementById("c" + valor);
				var emp = data.getAttribute("data-emp");
				var dir = data.getAttribute("data-dir");
				document.getElementById("empresa").value = emp;
				document.getElementById("direccion").value = dir;
			}
		}
    </script>
    <style>
        .input-group {
            margin: 2% auto;
        }
    </style>
</head>
<body>
	<?php
		require '../nav.php';
		$ventas = mysqli_query($con, "SELECT * FROM prefacturas WHERE Bodega='$bodega' AND Autorizado!='1' ORDER BY Fecha DESC");
	?>
	<table class="table table-striped" id="tabla">
		<thead>
			<tr>
				<th>Número</th>
				<th>Fecha</th>
				<th>Cliente</th>
				<th>Total</th>
				<th>Total pagado</th>
				<th>Estatus</th>
				<th><a class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#nuevo">Prefactura nueva</a></th>
				<th><input type="text" id="buscador" class="form-control" onkeyup="buscar()" placeholder="Buscar por cliente"></th>
			</tr>
		</thead>
		<tbody>
<?php
	$i = 0;
	while ($v = mysqli_fetch_assoc($ventas)){
	    $consec = $v["Consec"];
		$p = mysqli_fetch_assoc(mysqli_query($con, "SELECT SUM(Cantidad) AS Suma FROM pagos WHERE Carrito='p$consec'"))["Suma"];
		if ($p == null){
		    $pagado = 0;
		}
		else{
		    $pagado = $p;
		}
		$clase = "";
		//if ($v["Credito"] == '1'){
		//	$cred = "Con crédito";
		//	$clase = $clase . "cred ";
		//}
		//else{
		//	$cred = "Contado";
		//}
		$liq = "0";
		if ($v["Programado"] != '0'){
			$estado = "Programado";
			$envio = $v["Programado"];
			$fecha = mysqli_fetch_assoc(mysqli_query($con, "SELECT Fecha FROM envios WHERE Consec='$envio;"))["Fecha"];
		}
		else{
			$fecha = "-";
			if($v["Total"] <= $pagado){
				$liq = "1";
				$estado = "Liquidado";
			}
			else{
				if($pagado > 0){
					$estado = "Abonado";
				}
				else{
					$estado = "Pendiente de pago";
				}
			}
		}
		$cliente = $v["Cliente"];
		$consec = $v["Consec"];
		echo '
			<form action="verPagos.php" method="POST" id="pago', $i,'" style="display: none;">
				<input type="hidden" name="clave" value="p', $v["Consec"],'">
			</form>
			<form action="cotEstambre.php" method="POST" id="mod', $i,'" style="display: none;">
				<input type="hidden" name="prefac" value="', $v["Consec"],'">
				<input type="hidden" name="cliente" value="', $v["Cliente"],'">
			</form>
			<form action="borrCot.php" method="POST" id="borra', $i,'" style="display: none;">
				<input type="hidden" name="clave" value="', $v["Consec"],'">
			</form>
			<form action="autEst.php" method="POST" id="entr', $i,'" style="display: none;">
				<input type="hidden" name="clave" value="', $v["Consec"],'">
			</form>
			<tr id="', $v["Consec"],'" data-tipo="', $v["TipoPago"],'" data-ref="', $v["Referencia"],'" class="', $clase,'">
				<td>', $v["Consec"],'</td>
				<td>', $v["Fecha"],'</td>
				<td>', mysqli_fetch_assoc(mysqli_query($con, "SELECT Nombre FROM clientes WHERE Consec='$cliente'"))["Nombre"],'</td>
				<td>$', $v["Total"],'</td>
				<td>$', $pagado,'</td>
				<td>', $estado,'</td>
		';
		if ($liq == "1"){
			echo '
				<td><button class="btn btn-primary" onclick="document.getElementById(\'entr', $i,'\').submit()">Liberar entrega</button></td>
			';
		}
		else{
			echo '
				<td><button class="btn btn-primary" onclick="document.getElementById(\'pago', $i,'\').submit()">Registrar pagos</button></td>
			';
		}
		if ($pagado == 0){
			echo '
				<td><button class="btn btn-primary" onclick="document.getElementById(\'mod', $i,'\').submit()">Modificar</button></td>
				<td><button class="btn btn-primary" onclick="document.getElementById(\'borra', $i,'\').submit()">Borrar</button></td>
			';
		}
		else{
			echo '
				<td></td>
				<td></td>
			';
		}
		echo '
			</tr>
		';
		$i++;
	}
?>
		</tbody>
	</table>
	<div class="modal fade" data-bs-backdrop="static" tabindex="-1" role="dialog" id="detalles">
		<div class="modal-dialog modal-xl" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h3>Detalle</h3>
					<button type="button" class="btn-close" aria-label="close" data-bs-dismiss="modal"></button>
				</div>
				<div class="modal-body">
					<div class="input-group">
						<label class="input-group-text" for="tipo">Tipo de pago</label>
						<input type="text" class="form-control" name="nombre" id="tipo" disabled>
					</div>
					<div class="input-group">
						<label class="input-group-text" for="ref">Referencia</label>
						<input type="text" class="form-control" name="empresa" id="ref" disabled>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="modal fade" data-bs-backdrop="static" tabindex="-1" role="dialog" id="nuevo">
		<div class="modal-dialog modal-xl" role="document">
			<div class="modal-content">
			    <form action="cotEstambre.php" method="POST">
			        <input type="hidden" name="prefac" value="0">
				<div class="modal-header">
					<h3>Escoger cliente</h3>
					<button type="button" class="btn-close" aria-label="close" data-bs-dismiss="modal"></button>
				</div>
				<div class="modal-body">
					<div class="input-group">
						<label class="input-group-text" for="cliente">Cliente</label>
						<select class="form-select" name="cliente" id="cliente" onchange="cambioCliente()">
							<option value="">Seleccione</option>
							<option value="nuevo">Nuevo cliente</option>
				<?php
				    $tienda = "%" . mysqli_fetch_assoc(mysqli_query($con, "SELECT Clave FROM tiendas WHERE Bodega='$bodega'"))["Clave"] . "%";
					$clientes = mysqli_query($con, "SELECT * FROM clientes WHERE Tiendas LIKE '$tienda' ORDER BY Nombre");
					while ($c = mysqli_fetch_assoc($clientes)){
						echo '
							<option value="', $c["Consec"],'" id="c', $c["Consec"],'" data-emp="', $c["Empresa"],'" data-dir="', $c["Direccion"],'">', $c["Nombre"],'</option>
						';
					}
				?>
						</select>
					</div>
					<div class="input-group" id="desaparece" style="display: none;">
						<label class="input-group-text" for="nombre">Nombre</label>
						<input type="text" class="form-control" name="nombre" id="nombre">
					</div>
					<div class="input-group">
						<label class="input-group-text" for="empresa">Empresa</label>
						<input type="text" class="form-control" name="empresa" readonly id="empresa">
					</div>
					<div class="input-group">
						<label class="input-group-text" for="direccion">Dirección</label>
						<textarea class="form-control" readonly id="direccion" name="direccion"></textarea>
					</div>
				</div>
				<div class="modal-footer">
					<button type="submit" class="btn btn-primary float-right">Seleccionar</button>
				</div>
				</form>
			</div>
		</div>
	</div>
</body>
</html>


