<?php
	require('../tfpdf/tfpdf.php');
	session_start();
	require('../conexion.php');

	class PDF extends tFPDF{
		function Header(){
			$this->Image('../images/logo.gif',8,9,25);
			// Arial bold 10
			$this->SetFont('Arial','B',12);
			// Move to the right
			$this->Cell(1);
			$this->Ln(5);
			// Title
			$this->Cell(160,10,'HERRAMIENTAS EN PRESTAMO',0,0,'C');
			// Line break
			$this->Ln(15);
	        $this->SetFont('Arial','B',8);
	        $this->Cell(10,7,'No. EMP','B',0,'C');
	        $this->Cell(40,7,'NOMBRE','B',0,'C');
	        $this->Cell(10,7,'CVE HERR','B',0,'C');
	        $this->Cell(60,7,'NOMBRE','B',0,'C');
	        $this->Cell(25,7,'FECHA SAL','B',0,'C');
	        $this->Cell(25,7,'FECHA ENT','B',0,'C');
	        $this->Cell(15,7,'CANT','B',0,'C');
			$this->Ln(7);
		}

		function Footer(){
			global $hoy;
			// Position at 2.5 cm from bottom 
			$this->SetY(-15);
			// Arial italic 8
			$this->SetFont('Arial','I',8);
			$this->Cell(5,8,utf8_decode("Fecha de emisión     ").$hoy,0,0,'L');
			// Page number
			$this->Cell(0,8,utf8_decode('Página ').$this->PageNo().'/{nb}',0,0,'R');
		}
	}

//	$her = mysqli_query($con, "SELECT refemp.*,catr.Clave AS Cver,catr.Nombre AS Nomr, empf.Clave AS Cvee, empf.Nombre AS Nome FROM refempleados refemp JOIN catrefaciones catr ON refemp.Refaccion=catr.Clave JOIN empleadosfabrica empf ON refemp.Empleado=empf.Clave WHERE refemp.Tipo > 0 ORDER BY refemp.Empleado");
//	$her = mysqli_query($con, "SELECT * FROM refempleados WHERE Tipo > 0 ORDER BY Empleado");
	$her = mysqli_query($con, "SELECT ref.*,cr.Clave AS Cver,cr.Nombre AS Nomr, ef.Clave AS Cvee, ef.Nombre AS Nome FROM refempleados ref JOIN catrefacciones cr ON ref.Refaccion=cr.Clave JOIN empleadosfabrica ef ON ref.Empleado=ef.Clave WHERE ref.Tipo > 0 ORDER BY ref.Empleado");
	$hoy = date('Y/m/d');
	$pdf = new PDF();
	$pdf->AliasNbPages();
	$pdf->AddPage('P', 'A4', 0);
	$pdf->SetFont('Arial','',8);
	while ($e = mysqli_fetch_assoc($her)){
	    $pdf->Cell(10,7,$e["Empleado"],'B',0,'C');
	    $pdf->Cell(40,7,$e["Nome"],'B',0,'L');
	    $pdf->Cell(10,7,$e["Refaccion"],'B',0,'L');
		$pdf->Cell(60,7,$e["Nomr"],'B',0,'L');
		$pdf->Cell(25,7,$e["FecSal"],'B',0,'C');
		$pdf->Cell(25,7,$e["FecEnt"],'B',0,'C');
		$pdf->Cell(15,7,$e["Cant"],'B',0,'C');
	    $pdf->Ln(7);
	} 

	$pdf->Output();

?>


