<?php
	require '../Com.php';
	valUs();
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>Proveedor nuevo</title>
	<link rel="stylesheet" type="text/css" href="../css/bootstrap/css/bootstrap.min.css">
    <script src="../css/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <link rel="icon" href="../images/icon.png">
    <style type="text/css">
		form{
			width: 80%;
			margin: 10% auto;
		}

		.form-floating{
			margin: 2% 0;
		}
	</style>
	<script type="text/javascript">
	    function checa(){
    	    $.ajax({
    	        url: "checRfc.php",
    	        type: "POST",
    	        data: {'clave':$("#rfc").val(),},
    	        success: function (response) {
    	            if (response != false) {
    	                alert("Esc rfc ya fue usado en " + response);
    	            }
    	            else{
    	                alert("Rfc válido");
    	                document.getElementById("boton").disabled = false;
    	            }
    	        }
    	    });
    	}
    	
function rfcValido(rfc, aceptarGenerico = true) {
    const re       = /^([A-ZÑ&]{3,4}) ?(?:- ?)?(\d{2}(?:0[1-9]|1[0-2])(?:0[1-9]|[12]\d|3[01])) ?(?:- ?)?([A-Z0123456789\d]{2})([A\d])$/;
    var   validado = rfc.match(re);

    if (!validado)  //Coincide con el formato general del regex?
        return false;

    //Separar el dígito verificador del resto del RFC
    const digitoVerificador = validado.pop(),
          rfcSinDigito      = validado.slice(1).join(''),
          len               = rfcSinDigito.length,

    //Obtener el digito esperado
          diccionario       = "0123456789ABCDEFGHIJKLMN&OPQRSTUVWXYZ Ñ",
          indice            = len + 1;
    var   suma,
          digitoEsperado;

    if (len == 12) suma = 0
    else suma = 481; //Ajuste para persona moral

    for(var i=0; i<len; i++)
        suma += diccionario.indexOf(rfcSinDigito.charAt(i)) * (indice - i);
    digitoEsperado = 11 - suma % 11;
    if (digitoEsperado == 11) digitoEsperado = 0;
    else if (digitoEsperado == 10) digitoEsperado = "A";

    //El dígito verificador coincide con el esperado?
    // o es un RFC Genérico (ventas a público general)?
    if ((digitoVerificador != digitoEsperado)
     && (!aceptarGenerico || rfcSinDigito + digitoVerificador != "XAXX010101000"))
        return false;
    else if (!aceptarGenerico && rfcSinDigito + digitoVerificador == "XEXX010101000")
        return false;
    return rfcSinDigito + digitoVerificador;
}

function validarInput(input) {
    var rfc         = input.value.trim().toUpperCase();

    var rfcCorrecto = rfcValido(rfc);   // Acá se comprueba
  
    if (rfcCorrecto) {
        document.getElementById("checar").disabled = false;
        input.value = rfcCorrecto;
    }
    else {
    	document.getElementById("checar").disabled = true;;
    }
        
}
	</script>
</head>
<body>
	<?php
		require '../nav.php';
		$col = mysqli_query($con, "SELECT * FROM colores ORDER BY Clave");
	?>
	<h5>Catálogo de proveedores /Proveedor nuevo</h5>
	<form action="creaProv.php" method="POST">
	    <div class="form-floating input-group" id="refCont">
			<input id="rfc" type="text" name="rfc" placeholder="Rfc" class="form-control" required oninput="validarInput(this)">
			<label for="rfc" id="target">Rfc</label>
			<button type="button" class="btn btn-primary" onclick="checa()" id="checar" disabled>Checar</button>
		</div>
		<div class="form-floating">
			<input type="text" name="nombre" id="nombre" required class="form-control" oninput="this.value = this.value.toUpperCase()">
			<label for="nombre">Nombre</label>
		</div>
		<div class="form-check form-check-inline form-switch">
			<input type="checkbox" class="form-check-input" name="unico" id="unico" value="1">
			<label for="unico" class="form-check-label">Proveedor único</label>
		</div>
		<div class="form-check form-check-inline form-switch">
			<input type="checkbox" class="form-check-input" name="isr" id="isr" value="1">
			<label for="isr" class="form-check-label">¿Se retiene ISR?</label>
		</div>
		<div class="form-check form-check-inline form-switch">
			<input type="checkbox" class="form-check-input" name="retiva" id="retiva" value="1">
			<label for="retiva" class="form-check-label">¿Se retiene IVA?</label>
		</div>
		<br>
		<br>
		<button type="submit" class="btn btn-primary" disabled id="boton">Guardar</button>
	</form>
</body>
</html>

