<?php
	session_start();
	require '../conexion.php';
	require('../tfpdf/tfpdf.php');
	require('cantletra.php');
	
	class PDF extends tFPDF{
		function Header(){
		    global $cerem;
		    global $cuenta;
		    global $tipoPago;
		    global $cliente;
		    global $rfc;
		    global $nombre;
		    global $domicilio;
		    global $colonia;
		    global $ciudad;
		    global $cfdi;
		    global $regimen;
		    global $folio;
		    global $serie;

	    $this->Image('../images/logo.gif',4,20,30,15);
	    $this->line(5,10,210,10);
	    $this->SetFont('Arial','B',10);
	    $this->Ln();
	    $this->Cell(30,6," ",0,0,'L');
	    $this->Cell(60,6,"RFC 820127UFA",0,0,'L');
	    $this->Cell(80,6,"DATOS GENERALES",0,0,'L');
	    $this->Ln(5);
	    $this->SetFont('Arial','B',10);
	    $this->Cell(30,6," ",0,0,'L');
	    $this->Cell(60,6," ",0,0,'L');
	    $this->SetFont('Arial','',10);
	    $this->Cell(55,6,"FACTURA NUMERO",0,0,'L');
	    $this->Cell(40,6,$folio,0,0,'L');  
	    $this->Ln(5);
	    $this->Cell(30,6," ",0,0,'L');
	    $this->Cell(60,6," ",0,0,'L');
	    $this->Cell(55,6,"EFECTO DE COMPROBANTE",0,0,'L');
	    $this->Cell(40,6,"Ingreso",0,0,'L');
	    $this->Ln(5);
	    $this->SetFont('Arial','B',10);
	    $this->Cell(30,6," ",0,0,'L');
	    $this->Cell(60,6,"DOMICILIO FISCAL",0,0,'L');
	    $this->SetFont('Arial','',10);
	    $this->Cell(55,6,"SERIE",0,0,'L');
	    $this->Cell(40,6,$serie." Pedido: 347",0,0,'L');
	    $this->Ln(5);
	    $this->Cell(30,6," ",0,0,'L');
	    $this->Cell(60,6,"Avenida Vicente Aguirre del Castillo",0,0,'L');
	    $this->Cell(55,6,"FECHA Y HORA DE EMISION",0,0,'L');
	    $this->Cell(40,6,"2023-10-20 18:00",0,0,'L'); //ojo poner fecha
	    $this->Ln(5);
	    $this->Cell(30,6," ",0,0,'L');
	    $this->SetFont('Arial','',9);
	    $this->Cell(60,6,utf8_decode("No. 2300 Colonia San José Caltengo"),0,0,'L');
	    $this->SetFont('Arial','',10);
	    $this->Cell(55,6,"NUMERO DE CERTIFICADO",0,0,'L');
	    $this->Cell(40,6,$cerem,0,0,'L');
	    $this->Ln(5);
	    $this->Cell(30,6," ",0,0,'L');
	    $this->SetFont('Arial','',9);
	    $this->Cell(60,6,"C.P. 43628, Tulancingo de Bravo, Hidalgo",0,0,'L');
	    $this->SetFont('Arial','',10);
	    $this->Cell(55,6,"METODO DE PAGO Y CUENTA",0,0,'L');
	    $this->Cell(40,6,$cuenta.", CONTADO",0,0,'L');
	    $this->Ln(5);
	    $this->Cell(30,6," ",0,0,'L');
	    $this->Cell(60,6," ",0,0,'L');
	    $this->Cell(55,6,"FORMA DE PAGO",0,0,'L');
	    $this->SetTextColor(255,0,0);
	    $this->Cell(40,6,$tipoPago,0,0,'L');
	    $this->SetTextColor(0);
	    $this->Ln(5);

//	    $this->line(5,55,210,55);
	    $this->Cell(199,3," ","T",0,'L');
	    $this->SetFont('Arial','B',10);
	    $this->Ln(3);
	    $this->Cell(30,6,"RECEPTOR",0,0,'L');
	    $this->Cell(60,6," ",0,0,'L');
	    $this->Cell(80,6,"EMISOR",0,0,'L');
	    $this->Ln(4);
	    $this->SetFont('Arial','B',10);
	    $this->Cell(40,7,"CLIENTE:",0,0,'L');
	    $this->SetFont('Arial','',10);
	    $this->Cell(50,7,$cliente,0,0,'L');
	    $this->SetFont('Arial','B',10);
	    $this->Cell(40,7,"R F C:",0,0,'L');
	    $this->SetFont('Arial','',10);
	    $this->Cell(40,7,"COL820127UFA",0,0,'L');
	    $this->Ln(5);
	    $this->SetFont('Arial','B',10);
	    $this->Cell(40,7,"R F C:",0,0,'L');
	    $this->SetFont('Arial','',10);
	    $this->Cell(50,7,$rfc,0,0,'L');
	    $this->SetFont('Arial','B',10);
	    $this->Cell(40,7,"NOMBRE:",0,0,'L');
	    $this->SetFont('Arial','',10);
	    $this->Cell(40,7,"COLOMER",0,0,'L');
	    $this->Ln(5);
	    $this->SetFont('Arial','B',10);
	    $this->Cell(40,7,"NOMBRE:",0,0,'L');
	    $this->SetFont('Arial','',10);
	    $this->Cell(50,7,$nombre,0,0,'L');
	    $this->SetFont('Arial','B',10);
	    $this->Cell(40,7,"DOMICLIO:",0,0,'L');
	    $this->SetFont('Arial','',10);
	    $this->Cell(40,7,"ANDRES MOLINA ENRIQUEZ #195-BIS",0,0,'L');
	    $this->Ln(5);
	    $this->SetFont('Arial','B',10);
	    $this->Cell(40,7,"DOMICILIO:",0,0,'L');
	    $this->SetFont('Arial','',10);
	    $this->Cell(50,7,$domicilio,0,0,'L');
	    $this->SetFont('Arial','B',10);
	    $this->Cell(40,7,"COLONIA:",0,0,'L');
	    $this->SetFont('Arial','',10);
	    $this->Cell(40,7,"BARRIO SAN PEDRO IZTACALCO",0,0,'L');
	    $this->Ln(5);
	    $this->SetFont('Arial','B',10);
	    $this->Cell(40,7,"COLONIA Y CP:",0,0,'L');
	    $this->SetFont('Arial','',10);
	    $this->Cell(50,7,$colonia,0,0,'L');
	    $this->SetFont('Arial','B',10);
	    $this->Cell(40,7,"C. P.:",0,0,'L');
	    $this->SetFont('Arial','',10);
	    $this->Cell(40,7,"43628",0,0,'L');
	    $this->Ln(5);
	    $this->SetFont('Arial','B',10);
	    $this->Cell(40,7,"CIUDAD Y ESTADO:",0,0,'L');
	    $this->SetFont('Arial','',10);
	    $this->Cell(50,7,$ciudad,0,0,'L');
	    $this->SetFont('Arial','B',10);
	    $this->Cell(40,7,"CIUDAD Y ESTADO:",0,0,'L');
	    $this->SetFont('Arial','',10);
	    $this->Cell(40,7,"DEL. IZTACALCO",0,0,'L');
	    $this->Ln(5);
	    $this->SetFont('Arial','B',10);
	    $this->Cell(40,7,"USO DE CFDI:",0,0,'L');
	    $this->SetFont('Arial','',10);
	    $this->Cell(50,7,$cfdi,0,0,'L');
	    $this->SetFont('Arial','B',10);
	    $this->Cell(40,7,"PAIS:",0,0,'L');
	    $this->SetFont('Arial','',10);
	    $this->Cell(40,7,"MEXICO",0,0,'L');
	    $this->Ln(5);
	    $this->SetFont('Arial','B',10);
	    $this->Cell(40,7,"REGIMEN FISCAL:",0,0,'L');
	    $this->SetFont('Arial','',10);
	    $this->Cell(50,7,$regimen,0,0,'L');
	    $this->SetFont('Arial','B',10);
	    $this->Cell(40,7,"REGIMEN FISCAL:",0,0,'L');
	    $this->SetFont('Arial','',10);
	    $this->Cell(40,7,"601-General de Ley personas morales",0,0,'L');
	    $this->Ln(7);
		}

		function Footer(){
		}
	}
	
	$cer = $_POST["cer"];
	$scfd = $_POST["scf"];
	$ssat = $_POST["ssa"];
	$uu = $_POST["uu"];
	$cado = $_POST["cao"];
	$fect = $_POST["ft"];
	$cerprv = $_POST["cerp"];
	$rfcprv = $_POST["rfcp"];
	$ticket = $_POST["tkt"];
    $folio = $_POST["fol"];
    $serie = $_POST["serie"];
//    $textoqr = "https://verificacfdi.facturaelectronica.sat.gob.mx/default.aspx?id=feea73d6-385c-44b1-a325-85b35caffb80&re=COL820127UFA&rr=ACO880913LQ2&tt=1060.61&fe=2nAzDw==";
    $textoqr = $_POST["qr"];

    
	$resumen = mysqli_fetch_assoc(mysqli_query($con, "SELECT * FROM carresumen WHERE Ticket='$ticket'"));
	$consec = $resumen["Consec"];
	$carr = mysqli_query($con, "SELECT * FROM carritos WHERE NoCarr='$consec' AND Devuelto='0'");

	// datos generales
	$fecha = date("d-m-Y H:i:s");
	if ($resumen["Credito"] == "0"){
		$metPago = "CONTADO";
	}
	else{
		$metPago = "CREDITO";
	}
	$cuenta = "PUE";
    // Datos del emisor. Define Colomer
    $cpem = '43628';  //CP=domicilio fiscal emisor
    $cerem = '00001000000506484867';   //certificado emisor
    $serie = 'M';    //Serie de factura
    //$metpag = 'PUE';   //Metodo de pago PUE=pago en una sola exhibicion. PPD=parcialidades.
    $forpago = '01';  //Pago en efectivo
    $mon = 'MXN';

	// receptor  
	// esto lo puse yo para sacar los datos del cliente
	$numcli = $resumen["ClienteCons"];   
	$clidat = mysqli_fetch_assoc(mysqli_query($con, "SELECT * FROM datosfac WHERE Cliente='$numcli'"));

	$cliente = $clidat["Cliente"];
	$rfc = $clidat["Rfc"];
	$nombre = $clidat["Razon"];
	$domicilio = $clidat["Direccion"];
	$colonia = $clidat["Colonia"];
	$ciudad = $clidat["Ciudad"];
	$cfdi = "G03";
	$regimen = $clidat["Regimen"];
/*
	$cliente = $_POST["razon"];
	$rfc = $_POST["Rfc"];
	$nombre = $_POST["razon"];
	$domicilio = $_POST["Direccion"];
	$colonia = $_POST["Colonia"];
	$ciudad = $_POST["Ciudad"];
	$cfdi = $_POST["cfdi"];
	$regimen = $_POST["reg"];
	*/
	$tipoPago = $resumen["TipoPago"];


    include('../qrs/phpqrcode/qrlib.php'); 
    $codesDir = "";   
    $codeFile = 'qr.png';
    QRcode::png($textoqr, $codesDir.$codeFile, 'H', '4'); 

	$ren = 19;

	$pdf = new PDF();
	$pdf->AliasNbPages();
	$pdf->AddPage("P","LETTER",0);
	$pdf->SetFont('Arial','B',10);
	$pdf->Cell(40,7,"DETALLES",0,0,'L');
	$pdf->Ln(7);
    $pdf->SetFillColor(90);
    $pdf->SetTextColor(250);
	$pdf->SetFont('Arial','',8);
	$pdf->Cell(15,6,"Clave",0,0,'C',true);
	$pdf->Cell(15,6," ",0,0,'C',true);
	$pdf->Cell(15,6," ",0,0,'C',true);
	$pdf->Cell(20,6,"Unidad",0,0,'C',true);
	$pdf->Cell(70,6,utf8_decode("Descripción"),0,0,'C',true);
	$pdf->Cell(20,6,"Valor unitario",0,0,'C',true);
	$pdf->Cell(20,6,"Importe",0,0,'C',true);
	$pdf->Cell(20,6,"Descuento",0,0,'C',true);
	$pdf->Ln(5);
	$pdf->Cell(15,6,"ProdServ",0,0,'C',true);
	$pdf->Cell(15,6,utf8_decode("No Identif"),0,0,'C',true);
	$pdf->Cell(15,6,"Cantidad",0,0,'C',true);
    $pdf->SetFillColor(150);
	$pdf->Cell(20,6,"Base",0,0,'C',true);
	$pdf->Cell(70,6,utf8_decode("Importe"),0,0,'C',true);
	$pdf->Cell(20,6,"Factor",0,0,'C',true);
	$pdf->Cell(20,6,"Tipo",0,0,'C',true);
	$pdf->Cell(20,6,"Impuesto",0,0,'C',true);
	$pdf->Ln(6);
    $pdf->SetTextColor(1);
    $ren = $ren+2;
	

	// detalles
	while ($c = mysqli_fetch_assoc($carr)){
		$prod = $c["Nombre"];
		$p = mysqli_fetch_assoc(mysqli_query($con, "SELECT * FROM productos WHERE Nombre='$prod'"));
//		$cProdServ = $p["Clave"];
		$cProdServ = '11151704';
		$noInd = $prod;
		$cant = $c["Cant"];
		if ($p["Unidad"] == "kg"){
			$unidad = "KGM Kilo";
		}
		else {
			$unidad = $p["Unidad"];
		}
		$unitario = $c["Precio"];
		$descuento = $c["Descuento"];
		$importe = $cant * $unitario;
		$base = $importe - $descuento;
		$descripcion = $p["Descripcion"];
		$factor = 0.160;
		$iva = number_format($base * $factor,2);
		$ivaText = "IVA: " . $iva;
		$impuesto = "Tasa";
		$tipo = "002 - IVA";
	    $pdf->Cell(15,6,$cProdServ,"LR",0,'C');
	    $pdf->Cell(15,6,$noInd,"LR",0,'C');
	    $pdf->Cell(15,6,$cant,"LR",0,'C');
	    $pdf->Cell(20,6,$unidad,"LR",0,'C');
    	$pdf->Cell(70,6,$descripcion,"LR",0,'L');
	    $pdf->Cell(20,6,$unitario,"LR",0,'C');
	    $pdf->Cell(20,6,number_format($importe,2),"LR",0,'C');
	    $pdf->Cell(20,6,$descuento,"LR",0,'C');
	    $pdf->Ln(5);
        $ren = $ren+1;
	    $pdf->Cell(15,6," ","LR",0,'C');
	    $pdf->Cell(15,6," ","LR",0,'C');
	    $pdf->Cell(15,6," ","LR",0,'C');
	    $pdf->Cell(20,6,$base,"LR",0,'L');
    	$pdf->Cell(70,6,$ivaText,"LR",0,'L');
	    $pdf->Cell(20,6,$factor,"LR",0,'L');
	    $pdf->Cell(20,6,$tipo,"LR",0,'L');
	    $pdf->Cell(20,6,"Tasa","LR",0,'L');
	    $pdf->Ln(6);
        $ren = $ren+1;
    }
	$pdf->Cell(195,6," ","T",0,'L');
	// total
	$exento = "0.00";
	$subtotal = $resumen["Total"] / 1.16;
	$ieps = "0.00";
	$ivaTotal = $resumen["Total"] - $subtotal;
	$total = $resumen["Total"];
	$totlet = letra($total);
    $pdf->SetFillColor(90);
    $pdf->SetTextColor(250);
	$pdf->Ln(6);
    $ren = $ren+1;
	$pdf->Cell(150,6," ",0,0,'C');
	$pdf->Cell(20,6,"EXENTO",0,0,'L',true);
    $pdf->SetTextColor(1);
	$pdf->Cell(20,6,$exento,1,0,'L');
	$pdf->Ln(6);
    $ren = $ren+1;
	$pdf->Cell(150,6," ",0,0,'C');
    $pdf->SetTextColor(250);
	$pdf->Cell(20,6,"SUBTOTAL",0,0,'L',true);
    $pdf->SetTextColor(1);
	$pdf->Cell(20,6,number_format($subtotal,2),1,0,'L');
	$pdf->Ln(6);
    $ren = $ren+1;
	$pdf->Cell(150,6,"Cantidad con letra",0,0,'L');
    $pdf->SetTextColor(250);
	$pdf->Cell(20,6,"IEPS",0,0,'L',true);
    $pdf->SetTextColor(1);
	$pdf->Cell(20,6,$ieps,1,0,'L');
	$pdf->Ln(6);
    $ren = $ren+1;
	$pdf->Cell(150,6,$totlet,0,0,'L');
    $pdf->SetTextColor(250);
	$pdf->Cell(20,6,"I V A",0,0,'L',true);
    $pdf->SetTextColor(1);
	$pdf->Cell(20,6,number_format($ivaTotal,2),1,0,'L');
	$pdf->Ln(6);
    $ren = $ren+1;
	$pdf->Cell(150,6," ",0,0,'C');
    $pdf->SetTextColor(250);
	$pdf->Cell(20,6,"TOTAL",0,0,'L',true);
    $pdf->SetTextColor(1);
	$pdf->Cell(20,6,number_format($total,2),1,0,'L');
//  estos datos vienen del timbrado
    if ($ren <= 34){
	    $pdf->Ln(3);
        $pdf->SetFillColor(255);
	    $pdf->SetFont('Arial','',8);
	    $pdf->Cell(30,6,"Sello digital del CFDI: ",0,0,'L');
	    $pdf->Ln(5);
	    $pdf->MultiCell(190,3,$scfd,0,0,'L');
	    $pdf->Ln(1);
	    $pdf->Cell(30,5,"Sello digital del SAT:",0,0,'L');
	    $pdf->Ln(4);
	    $pdf->MultiCell(190,3,$ssat,0,0,'L');
	    $pdf->Ln(1);
	    $yy = $pdf->GetY();
	    $pdf->Image('qr.png',null,null,30,30);
        $pdf->SetY($yy+1);
        $pdf->Cell(30,4," ",0,0,'L');
	    $pdf->Cell(90,5,utf8_decode("Cadena original del complemento de verificacion del SAT:"),0,0,'L');
	    $pdf->Ln(4);
	    $pdf->Cell(30,4," ",0,0,'L');
	    $pdf->MultiCell(160,3,$cado,0,0,'L');
	    $pdf->Ln(1);
	    $pdf->Cell(40,4," ",0,0,'L');
	    $pdf->Cell(50,4,"Folio fiscal:",0,0,'L');
	    $pdf->Cell(70,4,$uu,0,0,'L');
	    $pdf->Ln(3);
	    $pdf->Cell(40,4," ",0,0,'L');
	    $pdf->Cell(50,4,"No. serie del certificado SAT:",0,0,'L');
	    $pdf->Cell(70,4,$cerprv,0,0,'L');
	    $pdf->Ln(3);
	    $pdf->Cell(40,4," ",0,0,'L');
	    $pdf->Cell(50,4,utf8_decode("Fecha y hora de certificación:"),0,0,'L');
	    $pdf->Cell(70,4,$fect,0,0,'L');
	    $pdf->Ln(3);
	    $pdf->Cell(40,4," ",0,0,'L');
	    $pdf->Cell(50,4,utf8_decode("RFC proveedor de certificación:"),0,0,'L');
	    $pdf->Cell(70,4,$rfcprv,0,0,'L');
    }
    else{
	    $pdf->AddPage("P","LETTER",0);
	    $ren = 19;
	    $pdf->Ln(3);
        $pdf->SetFillColor(255);
	    $pdf->SetFont('Arial','',8);
	    $pdf->Cell(30,6,"Sello digital del CFDI: ",0,0,'L');
	    $pdf->Ln(5);
	    $pdf->MultiCell(190,3,$scfd,0,0,'L');
	    $pdf->Ln(1);
	    $pdf->Cell(30,5,"Sello digital del SAT:",0,0,'L');
	    $pdf->Ln(4);
	    $pdf->MultiCell(190,3,$ssat,0,0,'L');
	    $pdf->Ln(1);
	    $yy = $pdf->GetY();
	    $pdf->Image('qr.png',null,null,30,30);
        $pdf->SetY($yy+1);
	    $pdf->Cell(30,4," ",0,0,'L');
	    $pdf->Cell(90,5,utf8_decode("Cadena original del complemento de verificacion del SAT:"),0,0,'L');
	    $pdf->Ln(4);
	    $pdf->Cell(30,4," ",0,0,'L');
	    $pdf->MultiCell(160,3,$cado,0,0,'L');
	    $pdf->Ln(1);
	    $pdf->Cell(40,4," ",0,0,'L');
	    $pdf->Cell(50,4,"Folio fiscal:",0,0,'L');
	    $pdf->Cell(70,4,$uu,0,0,'L');
	    $pdf->Ln(3);
	    $pdf->Cell(40,4," ",0,0,'L');
	    $pdf->Cell(50,4,"No. serie del certificado SAT:",0,0,'L');
	    $pdf->Cell(70,4,$cerprv,0,0,'L');
	    $pdf->Ln(3);
	    $pdf->Cell(40,4," ",0,0,'L');
	    $pdf->Cell(50,4,utf8_decode("Fecha y hora de certificación:"),0,0,'L');
	    $pdf->Cell(70,4,$fect,0,0,'L');
	    $pdf->Ln(3);
	    $pdf->Cell(40,4," ",0,0,'L');
	    $pdf->Cell(50,4,utf8_decode("RFC proveedor de certificación:"),0,0,'L');
	    $pdf->Cell(70,4,$rfcprv,0,0,'L');
    }

	$pdf->Output();
?>


