<?php
	require '../Com.php';
	valUs();
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>Precios</title>
	<link rel="stylesheet" type="text/css" href="../css/bootstrap/css/bootstrap.min.css">
    <script src="../css/bootstrap/js/bootstrap.bundle.min.js"></script>
    <link rel="icon" href="../images/icon.png">
</head>
<body>
	<?php
		require '../nav.php';
		$precios = mysqli_query($con, "SELECT * FROM perioprecios ORDER BY FechaIni DESC")
	?>
	<h5>Catálogo de precios</h5>
	<h6>Precios vigentes</h6>
	<table class="table">
	    <thead>
	        <tr>
	            <th>Peso</th>
	            <th>Sin iva</th>
	            <th>Con iva</th>
	        </tr>
	    </thead>
	    <tbody>
<?php
    $actuales = mysqli_query($con, "SELECT * FROM descuentos WHERE FecIni<=CURDATE() AND FecFin>=CURDATE() AND Promocion='0' ORDER BY Producto, Precio ASC");
    $clase = "";
    while ($a = mysqli_fetch_assoc($actuales)){
        $prod = $a["Producto"];
        if ($a["Min"] == "99999999.99"){
            $min = "Conos";
        }
        else{
            $min = $a["Min"];
        }
        if ($prod != $clase){
            $nomProd = mysqli_fetch_assoc(mysqli_query($con, "SELECT Nombre FROM clases WHERE Clave='$prod'"))["Nombre"];
            $clase = $prod;
            echo '
            <tr>
                <th colspan="3">', $nomProd,'</th>
            </tr>
            ';
        }
        echo '
            <tr>
                <td>', $min,'</td>
                <td>$', number_format($a["Precio"] / 1.16, 2),'</td>
                <td>$', $a["Precio"],'</td>
            </tr>
        ';
    }
?>
    <form action="modPrecios.php" method="POST" style="display: none;" id="nueva">
        <input type="hidden" name="consec" value="-1">
    </form>
	<table class="table table-striped">
		<thead>
			<tr>
				<th>Numero</th>
				<th>Fecha inicio</th>
				<th>Fecha fin</th>
				<th><input type="submit" class="btn btn-primary" form="nueva" value="Nuevos precios"></th>
			</tr>
		</thead>
		<tbody>
<?php
	$i = 0;
	while ($p = mysqli_fetch_assoc($precios)){
		echo '
			<form action="modPrecios.php" method="POST" id="modi', $i,'" style="display: none;">
				<input type="hidden" name="consec" value="', $p["Consec"],'">
			</form>
			<form action="llenarPrecios.php" method="POST" id="llen', $i,'" style="display: none;">
				<input type="hidden" name="consec" value="', $p["Consec"],'">
			</form>
			<tr>';
			echo '
				<td>', $p["Consec"],'</td>
				<td>', $p["FechaIni"],'</td>
				<td>', $p["FechaFin"],'</td>
				<td><button type="button" class="btn btn-primary" onclick="document.getElementById(\'modi', $i,'\').submit()">Modificar</button></td>
				<td><button type="button" class="btn btn-primary" onclick="document.getElementById(\'llen', $i,'\').submit()">Llenar</button></td>
			</tr>
		';
		$i++;
	}
?>
		</tbody>
	</table>
</body>
</html>


