<?php
	require '../Com.php';
	valUs();
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>Seguimiento de producción</title>
	<link rel="stylesheet" type="text/css" href="../css/bootstrap/css/bootstrap.min.css">
    <script src="../css/bootstrap/js/bootstrap.bundle.min.js"></script>
    <link rel="icon" href="../images/icon.png">
    <script type="text/javascript">
    	function buscaxnom() {
			var input, filter, table, tr, td, i, txtValue;
			input = document.getElementById("busxnom");
			filter = input.value.toUpperCase();
			table = document.getElementById("tabla");
			tr = table.getElementsByTagName("tr");

			for (i = 0; i < tr.length; i++) {
				td = tr[i].getElementsByTagName("td")[0];
				if (td) {
					txtValue = td.textContent || td.innerText;
					if (txtValue.toUpperCase().indexOf(filter) > -1) {
						tr[i].style.display = "";
					} else {
						tr[i].style.display = "none";
					}
				}
			}
		}
    </script>

</head>
<body>
	<?php
		require '../nav.php';
		//$plan = mysqli_query($con, "SELECT * FROM plan WHERE Completado='0' AND Consec IN (SELECT Plan FROM estimadoproduccion WHERE HoraEntReal<>'') ORDER BY Fecha ASC");
		$plan = mysqli_query($con, "SELECT * FROM plan WHERE Completado='0' AND WEEK(Fecha)>=(WEEK(CURDATE())-4) AND YEAR(Fecha)=YEAR(CURDATE()) ORDER BY Fecha ASC");
	?>
	<h5>Seguimiento de producción</h5>
	<table class="table table-striped" id="tabla">
		<thead>
			<tr>
			    <th>Teñida</th>
				<th>Fecha</th>
				<th>Hora de inicio</th>
				<th>Bodega actual</th>
				<th>Subproducto total</th>
				<th>Hora fin estimada</th>
				<th><input type="text" id="busxnom" class="form-control" onkeyup="buscaxnom()" placeholder="Buscar x teñida"></th>
	<?php
	    if ($user == "programacion"){
	        echo '
				<th></th>
	        ';
	    }
	?>
			</tr>
		</thead>
		<tbody>
<?php
	while ($p = mysqli_fetch_assoc($plan)){
		$consec = $p["Consec"];
//		$actual = $p["Actual"];
		$lote = $p["Lote"];
        $prod = mysqli_fetch_assoc(mysqli_query($con, "SELECT Entrado, Bodega FROM produccion WHERE Lote='$lote' ORDER BY HoraEnt DESC"));
        $actual = $prod["Bodega"];
		$bod = mysqli_fetch_assoc(mysqli_query($con, "SELECT Nombre FROM bodegas WHERE Num='$actual'"))["Nombre"];
		$estimado = mysqli_query($con, "SELECT * FROM estimadoproduccion WHERE Plan='$consec'");
		$victoria = true;
		$subprod = mysqli_fetch_assoc(mysqli_query($con, "SELECT SUM(Neto) AS Suma FROM subprod WHERE Lote='$lote'"))["Suma"];
		$saldos = mysqli_fetch_assoc(mysqli_query($con, "SELECT SUM(Peso) AS Suma FROM inventario WHERE Lote='$lote' AND Tipo!='prod'"))["Suma"];
		$peso = $subprod + $saldos;
		while ($e = mysqli_fetch_assoc($estimado)){
		    if ($victoria){
		        $inicio = $e["HoraEntReal"];
		        $victoria = false;
		    }
//		    if ($e["Bodega"] == $actual){
//		        $peso = $e["PesoReal"];
//		    }
			if ($e["HoraEntReal"] != ''){
				$fin = date_add(date_create($e["HoraEntReal"]), date_interval_create_from_date_string($e["TiempoEst"] . " minutes"));
			}
			else{
				$fin = date_add(date_create($e["HoraEntEst"]), date_interval_create_from_date_string($e["TiempoEst"] . " minutes"));
			}
		}
		echo '
			<tr>
			    <td>', $lote,'</td>
				<td>', $p["Fecha"],'</td>
				<td>', $inicio,'</td>
				<td>', $bod,'</td>
				<td>', $peso,'</td>
				<td>', date_format($fin, "d-m-Y H:i"),'</td>
				<td>
			        <form action="progSegSubDet.php" method="POST">
			        	<input type="hidden" name="plan" value="', $p["Consec"],'">
			        	<button type="submit" class="btn btn-primary">Ver detalle</button>
			        </form>
			    </td>';
			    if ($user=='programacion'){
			    echo '
			    <td>
			        <form action="reprocesos.php" method="POST">
			        	<input type="hidden" name="prod" value="', $p["Lote"],'">
			        	<button type="submit" class="btn btn-primary">Añadir reproceso</button>
			        </form>
			    </td>';
			    }
			 echo '
			</tr>
		';
	}
?>
		</tbody>
	</table>
</body>
</html>

