<?php
	require('../tfpdf/tfpdf.php');
	session_start();
	require('../conexion.php');

	class PDF extends tFPDF{
		function Header(){
		    global $lote;
		    global $disp;
			$this->Image('../images/logo.gif',8,9,25);
			// Arial bold 10
			$this->SetFont('Arial','B',12);
			// Move to the right
			$this->Cell(1);
			$this->Ln(5);
			// Title
			$this->Cell(160,10,'PUNTAJE POR HABILIDADES',0,0,'C');
			// Line break
			$this->Ln(15);
	        $this->SetFont('Arial','B',9);
	        $this->Cell(15,7,'NUM','B',0,'C');
	        $this->Cell(70,7,'NOMBRE','B',0,'C');
	        $this->Cell(40,7,'AREA','B',0,'C');
	        $this->Cell(55,7,'DESCRIPCION','B',0,'C');
	        $this->Cell(15,7,'PUNTOS','B',0,'C');
			$this->Ln(7);
		}

		function Footer(){
			global $hoy;
			// Position at 2.5 cm from bottom 
			$this->SetY(-15);
			// Arial italic 8
			$this->SetFont('Arial','I',8);
			$this->Cell(5,8,utf8_decode("Fecha de emisión     ").$hoy,0,0,'L');
			// Page number
			$this->Cell(0,8,utf8_decode('Página ').$this->PageNo().'/{nb}',0,0,'R');
		}
	}

	$empleados = mysqli_query($con, "SELECT empleadosfabrica.*,bodegas.Num,bodegas.Nombre AS Nom1 FROM empleadosfabrica LEFT JOIN bodegas ON empleadosfabrica.Area=bodegas.Num WHERE empleadosfabrica.Activo ORDER BY empleadosfabrica.Clave");

	$hoy = date('Y/m/d');
	$pdf = new PDF();
	$pdf->AliasNbPages();
	$pdf->AddPage('P', 'LETTER', 0);
	$pdf->SetFont('Arial','',8);
	while ($e = mysqli_fetch_assoc($empleados)){
	    $pdf->Cell(15,7,$e["Clave"],'B',0,'C');
	    $pdf->Cell(70,7,$e["Nombre"],'B',0,'L');
	    $pdf->Cell(40,7,utf8_encode($e["Nom1"]),'B',0,'L');
		$pdf->Cell(55,7,$e["Descripcion"],'B',0,'L');
		$pdf->Cell(15,7,$e["Puntos"],'B',0,'C');
	    $pdf->Ln(7);
	} 

	$pdf->Output();

?>


