<?php
	require '../Com.php';
	valUs();
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>Anilinas requeridas</title>
	<link rel="stylesheet" type="text/css" href="../css/bootstrap/css/bootstrap.min.css">
    <script src="../css/bootstrap/js/bootstrap.bundle.min.js"></script>
    <link rel="icon" href="../images/icon.png">
</head>
<body>
	<?php
		require '../nav.php';
		$hoy = date('Y-m-d');
		$sems = mysqli_fetch_assoc(mysqli_query($con, "SELECT * FROM semanasfabrica WHERE Ini<=CURDATE() AND FIN>=CURDATE() ORDER BY Ini ASC"));
		$max = $sems["Fin"];
		$anis = mysqli_query($con, "SELECT Nombre, Cantidad FROM formulas WHERE Plan IN (SELECT Consec FROM plan WHERE fecha>='$hoy' AND fecha<='$max')");
		$cuenta = array();
		while ($a = mysqli_fetch_assoc($anis)){
			if (array_key_exists($a["Nombre"], $cuenta)){
				$cuenta[$a["Nombre"]] = $cuenta[$a["Nombre"]] + $a["Cantidad"];
			}
			else{
				$cuenta[$a["Nombre"]] = $a["Cantidad"];
			}
		}
		$elems = array_keys($cuenta);
	?>
	<table class="table table-striped">
		<thead>
			<tr>
				<th>Anilina</th>
				<th>Cantidad requerida</th>
				<th>Stock</th>
				<th>Diferencia</th>
			</tr>
		</thead>
		<tbody>
<?php
	for ($j = 0; $j < count($elems); $j++){
		$nom = $elems[$j];
		$exis = mysqli_query($con, "SELECT ExisFab FROM insumos WHERE Nombre='$nom'");
		if (mysqli_num_rows($exis) == 0){
			$stock = 0;
		}
		else{
			$stock = mysqli_fetch_assoc($exis)["ExisFab"];
		}
		$diferencia = $stock - $cuenta[$nom];
		echo '
			<tr>
				<td>', $nom,'</td>
				<td>', $cuenta[$nom],'</td>
				<td>', $stock,'</td>
		';
		if ($diferencia < 0){
			echo '
				<td class="negativo">', $diferencia,'</td>
			';
		}
		else{
			echo '
				<td>', $diferencia,'</td>
			';
		}
		echo '
			</tr>
		';
	}
?>
		</tbody>
	</table>
</body>
</html>


